<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';

$urls = [
    url('/'),
    url('/plugins/'),
    url('/wiki/'),
];

$plugins = DB::query('SELECT slug FROM plugins WHERE is_active = 1')->fetchAll();
foreach ($plugins as $plugin) {
    $urls[] = url('/plugins/' . $plugin['slug']);
}

$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
$xml .= "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
foreach ($urls as $link) {
    $xml .= "  <url><loc>{$link}</loc></url>\n";
}
$xml .= "</urlset>\n";

file_put_contents(__DIR__ . '/../../public_html/sitemap.xml', $xml);
