<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';

$soon = (new DateTimeImmutable('+3 days'))->format('Y-m-d H:i:s');
$licenses = DB::query('SELECT licenses.*, users.email, plugins.name FROM licenses JOIN users ON users.id = licenses.user_id JOIN plugins ON plugins.id = licenses.plugin_id WHERE licenses.expires_at <= :soon AND licenses.status = \'active\'', [
    'soon' => $soon,
])->fetchAll();

foreach ($licenses as $license) {
    $subject = 'Lisansınız yakında bitiyor';
    $body = sprintf('<p>%s lisansınız %s tarihinde sona erecek.</p>', e($license['name']), e($license['expires_at']));
    Mailer::send($license['email'], $subject, $body);
}
