<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
$slug = $_GET['slug'] ?? '';
$page = DB::query('SELECT * FROM wiki_pages WHERE slug = :slug AND is_public = 1 LIMIT 1', ['slug' => $slug])->fetch();

if (!$page) {
    http_response_code(404);
    echo 'Wiki sayfası bulunamadı.';
    exit;
}

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container">
  <h1><?= e($page['title']) ?></h1>
  <div class="content-card">
    <?= $page['content_html'] ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
