<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';
$pages = DB::query('SELECT * FROM wiki_pages WHERE is_public = 1 ORDER BY sort_order ASC')->fetchAll();
include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="container">
  <h1>Wiki</h1>
  <ul class="list">
    <?php foreach ($pages as $page): ?>
      <li><a href="/wiki/view/?slug=<?= e($page['slug']) ?>"><?= e($page['title']) ?></a></li>
    <?php endforeach; ?>
  </ul>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
