<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/register/');
    }

    $email = trim($_POST['email'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (!Validator::email($email) || !Validator::minLength($password, 8)) {
        flash('error', 'Bilgiler geçersiz.');
        redirect('/register/');
    }

    DB::query('INSERT INTO users (role, email, username, password_hash, created_at, updated_at) VALUES (\'customer\', :email, :username, :hash, :created, :updated)', [
        'email' => $email,
        'username' => $username,
        'hash' => password_hash($password, PASSWORD_BCRYPT),
        'created' => now(),
        'updated' => now(),
    ]);

    flash('success', 'Kayıt tamamlandı.');
    redirect('/login/');
}

include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="auth-card">
  <h1>Kayıt Ol</h1>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
    <label>Kullanıcı Adı <input name="username" required></label>
    <label>Email <input type="email" name="email" required></label>
    <label>Şifre <input type="password" name="password" required></label>
    <button class="btn primary" type="submit">Kaydol</button>
  </form>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
