<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
$slug = $_GET['slug'] ?? '';
$plugin = DB::query('SELECT * FROM plugins WHERE slug = :slug LIMIT 1', ['slug' => $slug])->fetch();

if (!$plugin) {
    http_response_code(404);
    echo 'Plugin bulunamadı.';
    exit;
}

$comments = DB::query('SELECT comments.*, users.username FROM comments JOIN users ON users.id = comments.user_id WHERE plugin_id = :id AND status = \'approved\'', [
    'id' => $plugin['id'],
])->fetchAll();

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container">
  <div class="plugin-header" style="--plugin-primary: <?= e($plugin['theme_primary']) ?>; --plugin-accent: <?= e($plugin['theme_accent']) ?>;">
    <h1><?= e($plugin['name']) ?></h1>
    <p><?= e($plugin['short_description']) ?></p>
  </div>
  <div class="plugin-body">
    <?= $plugin['description_html'] ?>
  </div>
  <div class="plugin-actions">
    <a class="btn primary" href="/panel/">Satın Al</a>
    <a class="btn outline" href="/plugins/<?= e($plugin['slug']) ?>/wiki">Wiki</a>
  </div>
  <section class="comments">
    <h2>Yorumlar</h2>
    <?php foreach ($comments as $comment): ?>
      <div class="comment">
        <strong><?= e($comment['username']) ?></strong>
        <p><?= e($comment['content']) ?></p>
      </div>
    <?php endforeach; ?>
  </section>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
