<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';
$plugins = DB::query('SELECT * FROM plugins WHERE is_active = 1')->fetchAll();
include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="container">
  <h1>Eklentiler</h1>
  <div class="plugin-grid">
    <?php foreach ($plugins as $plugin): ?>
      <article class="plugin-card" style="--plugin-primary: <?= e($plugin['theme_primary']) ?>; --plugin-accent: <?= e($plugin['theme_accent']) ?>;">
        <h3><?= e($plugin['name']) ?></h3>
        <p><?= e($plugin['short_description']) ?></p>
        <div class="card-actions">
          <a class="btn small" href="/plugins/<?= e($plugin['slug']) ?>">Detay</a>
        </div>
      </article>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
