<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';

$token = $_GET['token'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/password/reset/?token=' . urlencode($token));
    }
    $password = trim($_POST['password'] ?? '');
    $token = trim($_POST['token'] ?? '');
    $row = DB::query('SELECT * FROM password_resets WHERE token = :token AND expires_at > :now', [
        'token' => $token,
        'now' => now(),
    ])->fetch();
    if (!$row) {
        flash('error', 'Token geçersiz.');
        redirect('/password/forgot/');
    }
    DB::query('UPDATE users SET password_hash = :hash WHERE email = :email', [
        'hash' => password_hash($password, PASSWORD_BCRYPT),
        'email' => $row['email'],
    ]);
    DB::query('DELETE FROM password_resets WHERE email = :email', ['email' => $row['email']]);
    flash('success', 'Şifreniz güncellendi.');
    redirect('/login/');
}

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="auth-card">
  <h1>Yeni Şifre</h1>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
    <input type="hidden" name="token" value="<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>">
    <label>Şifre <input type="password" name="password" required></label>
    <button class="btn primary" type="submit">Güncelle</button>
  </form>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
