<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/password/forgot/');
    }
    $email = trim($_POST['email'] ?? '');
    $token = bin2hex(random_bytes(16));
    DB::query('INSERT INTO password_resets (email, token, expires_at) VALUES (:email, :token, :expires)', [
        'email' => $email,
        'token' => $token,
        'expires' => date('Y-m-d H:i:s', time() + 3600),
    ]);
    flash('info', 'Şifre sıfırlama bağlantısı gönderildi.');
    redirect('/login/');
}

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="auth-card">
  <h1>Şifre Sıfırlama</h1>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
    <label>Email <input type="email" name="email" required></label>
    <button class="btn primary" type="submit">Gönder</button>
  </form>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
