<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::check()) {
    redirect('/login/');
}
$user = Auth::user();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/panel/security/');
    }
    $password = trim($_POST['password'] ?? '');
    if (strlen($password) < 8) {
        flash('error', 'Şifre en az 8 karakter olmalı.');
        redirect('/panel/security/');
    }
    DB::query('UPDATE users SET password_hash = :hash, updated_at = :updated WHERE id = :id', [
        'hash' => password_hash($password, PASSWORD_BCRYPT),
        'updated' => now(),
        'id' => $user['id'],
    ]);
    flash('success', 'Şifre güncellendi.');
    redirect('/panel/security/');
}
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Güvenlik</h1>
    <form method="post">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Yeni Şifre <input type="password" name="password" required></label>
      <button class="btn primary" type="submit">Güncelle</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
