<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::check()) {
    redirect('/login/');
}
$user = Auth::user();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/panel/profile/');
    }
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    DB::query('UPDATE users SET username = :username, email = :email, updated_at = :updated WHERE id = :id', [
        'username' => $username,
        'email' => $email,
        'updated' => now(),
        'id' => $user['id'],
    ]);
    flash('success', 'Profil güncellendi.');
    redirect('/panel/profile/');
}
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Profil</h1>
    <form method="post">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Kullanıcı Adı <input name="username" value="<?= e($user['username']) ?>"></label>
      <label>Email <input type="email" name="email" value="<?= e($user['email']) ?>"></label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
