<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::check()) {
    redirect('/login/');
}
$orders = DB::query('SELECT * FROM orders WHERE user_id = :user ORDER BY created_at DESC', [
    'user' => Auth::user()['id'],
])->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Siparişler</h1>
    <?php foreach ($orders as $order): ?>
      <div class="content-card">
        <strong><?= e($order['order_no']) ?></strong>
        <p>Durum: <?= e($order['status']) ?></p>
        <p>Tutar: ₺<?= number_format((float) $order['total_try'], 2) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
