<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::check()) {
    redirect('/login/');
}
$licenses = DB::query('SELECT licenses.*, plugins.name FROM licenses JOIN plugins ON plugins.id = licenses.plugin_id WHERE user_id = :user', [
    'user' => Auth::user()['id'],
])->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Lisanslar</h1>
    <?php foreach ($licenses as $license): ?>
      <div class="content-card">
        <strong><?= e($license['name']) ?></strong>
        <p>Durum: <?= e($license['status']) ?></p>
        <p>Bitiş: <?= e($license['expires_at']) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
