<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';

if (!Auth::check()) {
    redirect('/login/');
}

$licenses = DB::query('SELECT licenses.*, plugins.name FROM licenses JOIN plugins ON plugins.id = licenses.plugin_id WHERE user_id = :user', [
    'user' => Auth::user()['id'],
])->fetchAll();

$announcements = DB::query('SELECT * FROM announcements WHERE is_active = 1 ORDER BY created_at DESC LIMIT 3')->fetchAll();

include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Dashboard</h1>
    <div class="cards">
      <?php foreach ($licenses as $license): ?>
        <div class="content-card">
          <strong><?= e($license['name']) ?></strong>
          <p>Durum: <?= e($license['status']) ?></p>
          <p>Bitiş: <?= e($license['expires_at']) ?></p>
        </div>
      <?php endforeach; ?>
    </div>
    <h2>Duyurular</h2>
    <?php foreach ($announcements as $announcement): ?>
      <div class="announcement">
        <strong><?= e($announcement['title']) ?></strong>
        <p><?= e($announcement['content']) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
