<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::check()) {
    redirect('/login/');
}
$downloads = DB::query('SELECT download_logs.*, plugins.name FROM download_logs JOIN plugins ON plugins.id = download_logs.plugin_id WHERE user_id = :user ORDER BY created_at DESC', [
    'user' => Auth::user()['id'],
])->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/panel_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>İndirme Geçmişi</h1>
    <?php foreach ($downloads as $download): ?>
      <div class="content-card">
        <strong><?= e($download['name']) ?></strong>
        <p><?= e($download['created_at']) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
