<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/login/');
    }

    if (!Security::rateLimit('login', 5, 300)) {
        flash('error', 'Çok fazla deneme. Lütfen bekleyin.');
        redirect('/login/');
    }

    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (Auth::attempt($email, $password)) {
        flash('success', 'Hoş geldiniz.');
        redirect('/panel/');
    }

    flash('error', 'Giriş başarısız.');
    redirect('/login/');
}

include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="auth-card">
  <h1>Giriş</h1>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
    <label>Email <input type="email" name="email" required></label>
    <label>Şifre <input type="password" name="password" required></label>
    <button class="btn primary" type="submit">Giriş</button>
  </form>
  <a href="/password/forgot/">Şifremi unuttum</a>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
