<?php
declare(strict_types=1);

$lockFile = __DIR__ . '/.lock';
if (file_exists($lockFile)) {
    echo 'Kurulum kilitli. install/ dizinini kaldırabilir veya .lock dosyasını silebilirsiniz.';
    exit;
}

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
$step = (int) ($_GET['step'] ?? 1);
$errors = [];
$data = $_SESSION['install'] ?? [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $step = (int) ($_POST['step'] ?? $step);

    if ($step === 2) {
        $data['DB_HOST'] = trim($_POST['db_host'] ?? 'localhost');
        $data['DB_PORT'] = trim($_POST['db_port'] ?? '3306');
        $data['DB_NAME'] = trim($_POST['db_name'] ?? '');
        $data['DB_USER'] = trim($_POST['db_user'] ?? '');
        $data['DB_PASS'] = trim($_POST['db_pass'] ?? '');
        if ($data['DB_NAME'] === '' || $data['DB_USER'] === '') {
            $errors[] = 'Veritabanı adı ve kullanıcı zorunludur.';
        } else {
            $step = 3;
        }
    } elseif ($step === 3) {
        try {
            $dsn = sprintf('mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4', $data['DB_HOST'], $data['DB_PORT'], $data['DB_NAME']);
            $pdo = new PDO($dsn, $data['DB_USER'], $data['DB_PASS'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            ]);
            $schema = file_get_contents(__DIR__ . '/../../sql/schema.sql');
            $pdo->exec($schema);
            $step = 4;
        } catch (Throwable $e) {
            $errors[] = 'Şema kurulamadı: ' . $e->getMessage();
        }
    } elseif ($step === 4) {
        $data['admin_email'] = trim($_POST['admin_email'] ?? '');
        $data['admin_password'] = trim($_POST['admin_password'] ?? '');
        if (!filter_var($data['admin_email'], FILTER_VALIDATE_EMAIL) || strlen($data['admin_password']) < 8) {
            $errors[] = 'Geçerli email ve en az 8 karakterli şifre girin.';
        } else {
            $step = 5;
        }
    } elseif ($step === 5) {
        $data['site_name'] = trim($_POST['site_name'] ?? 'xoraGames');
        $data['base_url'] = trim($_POST['base_url'] ?? '');
        $data['currency'] = trim($_POST['currency'] ?? 'TRY');
        $data['smtp_host'] = trim($_POST['smtp_host'] ?? '');
        $data['smtp_user'] = trim($_POST['smtp_user'] ?? '');
        $data['smtp_pass'] = trim($_POST['smtp_pass'] ?? '');
        $data['smtp_from'] = trim($_POST['smtp_from'] ?? '');
        $step = 6;
    } elseif ($step === 6) {
        $appKey = bin2hex(random_bytes(32));
        $config = [
            'APP_ENV' => 'production',
            'APP_KEY' => $appKey,
            'APP_DEBUG' => false,
            'APP_BASE_URL' => $data['base_url'],
            'DB_HOST' => $data['DB_HOST'],
            'DB_PORT' => $data['DB_PORT'],
            'DB_NAME' => $data['DB_NAME'],
            'DB_USER' => $data['DB_USER'],
            'DB_PASS' => $data['DB_PASS'],
            'SESSION_TIMEOUT' => 3600,
            'LICENSE_GRACE_DAYS' => 3,
        ];

        $configFile = __DIR__ . '/../../app/config/config.php';
        $content = "<?php\n" . 'declare(strict_types=1);' . "\n\n" . '$config = ' . var_export($config, true) . ";\n" . '$GLOBALS[\'config\'] = $config;' . "\n";
        file_put_contents($configFile, $content);

        $dsn = sprintf('mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4', $data['DB_HOST'], $data['DB_PORT'], $data['DB_NAME']);
        $pdo = new PDO($dsn, $data['DB_USER'], $data['DB_PASS'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);

        $passwordHash = password_hash($data['admin_password'], PASSWORD_BCRYPT);
        $now = date('Y-m-d H:i:s');
        $pdo->prepare('INSERT INTO users (role, email, username, password_hash, created_at, updated_at) VALUES (\'admin\', :email, :username, :hash, :created, :updated)')
            ->execute([
                'email' => $data['admin_email'],
                'username' => 'admin',
                'hash' => $passwordHash,
                'created' => $now,
                'updated' => $now,
            ]);

        $pdo->prepare('INSERT INTO settings (id, site_name, base_url, app_key, updated_at, smtp_host, smtp_user, smtp_pass_enc, smtp_from) VALUES (1, :site, :base, :app_key, :updated, :smtp_host, :smtp_user, :smtp_pass, :smtp_from)')
            ->execute([
                'site' => $data['site_name'],
                'base' => $data['base_url'],
                'app_key' => $appKey,
                'updated' => $now,
                'smtp_host' => $data['smtp_host'] ?: null,
                'smtp_user' => $data['smtp_user'] ?: null,
                'smtp_pass' => $data['smtp_pass'] ?: null,
                'smtp_from' => $data['smtp_from'] ?: null,
            ]);

        file_put_contents($lockFile, 'locked');
        unset($_SESSION['install']);
        header('Location: /');
        exit;
    }

    $_SESSION['install'] = $data;
}

$checks = [
    'PHP 8.1+' => version_compare(PHP_VERSION, '8.1.0', '>='),
    'pdo_mysql' => extension_loaded('pdo_mysql'),
    'openssl' => extension_loaded('openssl'),
    'mbstring' => extension_loaded('mbstring'),
    'curl' => extension_loaded('curl'),
    'json' => extension_loaded('json'),
    'fileinfo' => extension_loaded('fileinfo'),
];
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kurulum - xoraGames</title>
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body class="install">
  <div class="install-card">
    <h1>Kurulum Sihirbazı</h1>
    <?php if ($errors): ?>
      <div class="alert error">
        <?php foreach ($errors as $error): ?>
          <p><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></p>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <?php if ($step === 1): ?>
      <h2>Sistem Kontrolü</h2>
      <ul class="checklist">
        <?php foreach ($checks as $label => $ok): ?>
          <li class="<?= $ok ? 'ok' : 'fail' ?>"><?= $label ?></li>
        <?php endforeach; ?>
      </ul>
      <form method="post">
        <input type="hidden" name="step" value="2">
        <button class="btn primary" type="submit">Devam Et</button>
      </form>
    <?php elseif ($step === 2): ?>
      <h2>Veritabanı Bilgileri</h2>
      <form method="post">
        <input type="hidden" name="step" value="2">
        <label>Host <input name="db_host" value="<?= htmlspecialchars($data['DB_HOST'] ?? 'localhost') ?>"></label>
        <label>Port <input name="db_port" value="<?= htmlspecialchars($data['DB_PORT'] ?? '3306') ?>"></label>
        <label>DB Adı <input name="db_name" required></label>
        <label>Kullanıcı <input name="db_user" required></label>
        <label>Şifre <input name="db_pass" type="password"></label>
        <button class="btn primary" type="submit">Devam</button>
      </form>
    <?php elseif ($step === 3): ?>
      <h2>Tabloları Oluştur</h2>
      <p>Şema oluşturulacak.</p>
      <form method="post">
        <input type="hidden" name="step" value="3">
        <button class="btn primary" type="submit">Şemayı Kur</button>
      </form>
    <?php elseif ($step === 4): ?>
      <h2>İlk Admin Hesabı</h2>
      <form method="post">
        <input type="hidden" name="step" value="4">
        <label>Email <input name="admin_email" type="email" required></label>
        <label>Şifre <input name="admin_password" type="password" required></label>
        <button class="btn primary" type="submit">Devam</button>
      </form>
    <?php elseif ($step === 5): ?>
      <h2>Temel Ayarlar</h2>
      <form method="post">
        <input type="hidden" name="step" value="5">
        <label>Site Adı <input name="site_name" value="<?= htmlspecialchars($data['site_name'] ?? 'xoraGames') ?>"></label>
        <label>Base URL <input name="base_url" value="<?= htmlspecialchars($data['base_url'] ?? '') ?>"></label>
        <label>Para Birimi <input name="currency" value="TRY"></label>
        <label>SMTP Host <input name="smtp_host"></label>
        <label>SMTP Kullanıcı <input name="smtp_user"></label>
        <label>SMTP Şifre <input name="smtp_pass" type="password"></label>
        <label>SMTP From <input name="smtp_from"></label>
        <button class="btn primary" type="submit">Kurulumu Tamamla</button>
      </form>
    <?php elseif ($step === 6): ?>
      <h2>Kurulum Tamamlanıyor</h2>
      <form method="post">
        <input type="hidden" name="step" value="6">
        <button class="btn primary" type="submit">Bitir</button>
      </form>
    <?php endif; ?>
  </div>
</body>
</html>
