<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/bootstrap.php';

$plugins = DB::query('SELECT * FROM plugins WHERE is_active = 1 ORDER BY created_at DESC')->fetchAll();
$announcements = DB::query('SELECT * FROM announcements WHERE is_active = 1 ORDER BY created_at DESC LIMIT 5')->fetchAll();

include __DIR__ . '/../app/views/partials/header.php';
?>
<section class="hero">
  <div class="container">
    <h1>Minecraft eklentileriniz için profesyonel lisans platformu</h1>
    <p>Güvenli ödeme, aylık lisans yönetimi ve güçlü doğrulama API'si.</p>
    <div class="cta">
      <a class="btn primary" href="/plugins/">Eklentileri İncele</a>
      <a class="btn outline" href="/panel/">Panel</a>
    </div>
  </div>
</section>
<section class="container grid">
  <div class="grid-main">
    <h2>Eklentiler</h2>
    <div class="plugin-grid">
      <?php foreach ($plugins as $plugin): ?>
        <article class="plugin-card" style="--plugin-primary: <?= e($plugin['theme_primary']) ?>; --plugin-accent: <?= e($plugin['theme_accent']) ?>;">
          <h3><?= e($plugin['name']) ?></h3>
          <p><?= e($plugin['short_description']) ?></p>
          <div class="card-actions">
            <a class="btn small" href="/plugins/<?= e($plugin['slug']) ?>">Detay</a>
            <span class="price">₺<?= number_format((float) $plugin['price_monthly_try'], 2) ?>/ay</span>
          </div>
        </article>
      <?php endforeach; ?>
    </div>
  </div>
  <aside class="grid-side">
    <h3>Duyurular</h3>
    <?php foreach ($announcements as $announcement): ?>
      <div class="announcement">
        <strong><?= e($announcement['title']) ?></strong>
        <p><?= e($announcement['content']) ?></p>
      </div>
    <?php endforeach; ?>
  </aside>
</section>
<?php include __DIR__ . '/../app/views/partials/footer.php'; ?>
