<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/bootstrap.php';
$token = $_GET['token'] ?? '';
$row = DB::query('SELECT download_tokens.*, plugin_versions.file_path, plugin_versions.plugin_id, plugin_versions.id as version_id FROM download_tokens JOIN plugin_versions ON plugin_versions.id = download_tokens.version_id WHERE token = :token', [
    'token' => $token,
])->fetch();

if (!$row || strtotime($row['expires_at']) < time()) {
    http_response_code(404);
    exit('Token geçersiz.');
}

$file = __DIR__ . '/../app/storage/' . $row['file_path'];
if (!file_exists($file)) {
    http_response_code(404);
    exit('Dosya bulunamadı.');
}

header('Content-Type: application/java-archive');
header('Content-Disposition: attachment; filename="plugin.jar"');
readfile($file);

DB::query('DELETE FROM download_tokens WHERE token = :token', ['token' => $token]);
