<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';

if (!Auth::check()) {
    redirect('/login/');
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect('/');
}

if (!CSRF::validate($_POST['_csrf'] ?? '')) {
    flash('error', 'Geçersiz CSRF.');
    redirect('/');
}

if (!Security::rateLimit('comment_post', 5, 300)) {
    flash('error', 'Çok fazla deneme.');
    redirect('/');
}

DB::query('INSERT INTO comments (plugin_id, user_id, content, status, created_at, updated_at) VALUES (:plugin, :user, :content, \'pending\', :created, :updated)', [
    'plugin' => (int) $_POST['plugin_id'],
    'user' => Auth::user()['id'],
    'content' => trim($_POST['content'] ?? ''),
    'created' => now(),
    'updated' => now(),
]);

flash('success', 'Yorumunuz moderasyon için gönderildi.');
redirect('/plugins/' . $_POST['plugin_slug']);
