<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
$slug = $_GET['slug'] ?? '';
$plugin = DB::query('SELECT * FROM plugins WHERE slug = :slug', ['slug' => $slug])->fetch();
if (!$plugin) {
    http_response_code(404);
    echo 'Plugin bulunamadı.';
    exit;
}
$versions = DB::query('SELECT * FROM plugin_versions WHERE plugin_id = :id ORDER BY created_at DESC', ['id' => $plugin['id']])->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container">
  <h1><?= e($plugin['name']) ?> - Sürüm Notları</h1>
  <?php foreach ($versions as $version): ?>
    <div class="content-card">
      <strong><?= e($version['version']) ?></strong>
      <pre><?= e($version['changelog_md']) ?></pre>
    </div>
  <?php endforeach; ?>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
