<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';

if (!Auth::check()) {
    redirect('/login/');
}

$bugs = DB::query('SELECT bug_reports.*, plugins.name AS plugin_name FROM bug_reports JOIN plugins ON plugins.id = bug_reports.plugin_id WHERE user_id = :user ORDER BY created_at DESC', [
    'user' => Auth::user()['id'],
])->fetchAll();

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container">
  <h1>Bug Raporlarım</h1>
  <?php foreach ($bugs as $bug): ?>
    <div class="content-card">
      <strong><?= e($bug['title']) ?></strong>
      <p><?= e($bug['plugin_name']) ?> - <?= e($bug['status']) ?></p>
    </div>
  <?php endforeach; ?>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
