<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';

if (!Auth::check()) {
    redirect('/login/');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/bugs/submit/');
    }

    if (!Security::rateLimit('bug_submit', 5, 300)) {
        flash('error', 'Çok fazla deneme.');
        redirect('/bugs/submit/');
    }

    DB::query('INSERT INTO bug_reports (plugin_id, user_id, title, description, severity, status, created_at, updated_at) VALUES (:plugin, :user, :title, :desc, :severity, \'open\', :created, :updated)', [
        'plugin' => (int) $_POST['plugin_id'],
        'user' => Auth::user()['id'],
        'title' => trim($_POST['title'] ?? ''),
        'desc' => trim($_POST['description'] ?? ''),
        'severity' => $_POST['severity'] ?? 'low',
        'created' => now(),
        'updated' => now(),
    ]);
    flash('success', 'Bug bildirimi alındı.');
    redirect('/panel/');
}

$plugins = DB::query('SELECT id, name FROM plugins WHERE is_active = 1')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container">
  <h1>Bug Bildir</h1>
  <form method="post">
    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
    <label>Eklenti
      <select name="plugin_id">
        <?php foreach ($plugins as $plugin): ?>
          <option value="<?= e((string) $plugin['id']) ?>"><?= e($plugin['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </label>
    <label>Başlık <input name="title" required></label>
    <label>Açıklama <textarea name="description" required></textarea></label>
    <label>Seviye
      <select name="severity">
        <option value="low">Düşük</option>
        <option value="medium">Orta</option>
        <option value="high">Yüksek</option>
        <option value="critical">Kritik</option>
      </select>
    </label>
    <button class="btn primary" type="submit">Gönder</button>
  </form>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
