document.addEventListener('DOMContentLoaded', () => {
  const toasts = document.querySelectorAll('.toast');
  toasts.forEach((toast) => {
    setTimeout(() => {
      toast.style.opacity = '0';
      toast.style.transform = 'translateY(-6px)';
      setTimeout(() => toast.remove(), 400);
    }, 4000);
  });

  const banner = document.querySelector('.cookie-banner');
  const button = document.getElementById('cookie-accept');
  if (banner && button) {
    if (localStorage.getItem('cookieConsent')) {
      banner.remove();
    } else {
      button.addEventListener('click', () => {
        localStorage.setItem('cookieConsent', '1');
        banner.remove();
      });
    }
  }
});
