<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/users/');
    }
    DB::query('UPDATE users SET role = :role, updated_at = :updated WHERE id = :id', [
        'role' => $_POST['role'] ?? 'customer',
        'updated' => now(),
        'id' => (int) $_POST['user_id'],
    ]);
    flash('success', 'Rol güncellendi.');
    redirect('/admin/users/');
}

$users = DB::query('SELECT id, email, username, role FROM users ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Kullanıcılar</h1>
    <?php foreach ($users as $user): ?>
      <form method="post" class="content-card">
        <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
        <input type="hidden" name="user_id" value="<?= e((string) $user['id']) ?>">
        <strong><?= e($user['username']) ?> (<?= e($user['email']) ?>)</strong>
        <select name="role">
          <?php foreach (['admin','staff_support','editor','customer'] as $role): ?>
            <option value="<?= $role ?>" <?= $user['role'] === $role ? 'selected' : '' ?>><?= $role ?></option>
          <?php endforeach; ?>
        </select>
        <button class="btn small" type="submit">Güncelle</button>
      </form>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
