<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$settings = DB::query('SELECT * FROM settings WHERE id = 1')->fetch();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/settings/smtp/');
    }

    DB::query('UPDATE settings SET smtp_host = :host, smtp_port = :port, smtp_user = :user, smtp_pass_enc = :pass, smtp_from = :from, smtp_secure = :secure, updated_at = :updated WHERE id = 1', [
        'host' => trim($_POST['smtp_host'] ?? ''),
        'port' => trim($_POST['smtp_port'] ?? ''),
        'user' => trim($_POST['smtp_user'] ?? ''),
        'pass' => trim($_POST['smtp_pass_enc'] ?? ''),
        'from' => trim($_POST['smtp_from'] ?? ''),
        'secure' => trim($_POST['smtp_secure'] ?? ''),
        'updated' => now(),
    ]);
    flash('success', 'SMTP ayarları güncellendi.');
    redirect('/admin/settings/smtp/');
}

include __DIR__ . '/../../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>SMTP Ayarları</h1>
    <form method="post" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Host <input name="smtp_host" value="<?= e($settings['smtp_host'] ?? '') ?>"></label>
      <label>Port <input name="smtp_port" value="<?= e($settings['smtp_port'] ?? '') ?>"></label>
      <label>Kullanıcı <input name="smtp_user" value="<?= e($settings['smtp_user'] ?? '') ?>"></label>
      <label>Şifre <input type="password" name="smtp_pass_enc" value="<?= e($settings['smtp_pass_enc'] ?? '') ?>"></label>
      <label>From <input name="smtp_from" value="<?= e($settings['smtp_from'] ?? '') ?>"></label>
      <label>Secure <input name="smtp_secure" value="<?= e($settings['smtp_secure'] ?? '') ?>"></label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../../app/views/partials/footer.php'; ?>
