<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$settings = DB::query('SELECT * FROM settings WHERE id = 1')->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/settings/');
    }

    DB::query('UPDATE settings SET site_name = :site, base_url = :base, maintenance_mode = :maintenance, maintenance_message = :message, support_email = :support, contact_email = :contact, updated_at = :updated WHERE id = 1', [
        'site' => trim($_POST['site_name'] ?? ''),
        'base' => trim($_POST['base_url'] ?? ''),
        'maintenance' => isset($_POST['maintenance_mode']) ? 1 : 0,
        'message' => trim($_POST['maintenance_message'] ?? ''),
        'support' => trim($_POST['support_email'] ?? ''),
        'contact' => trim($_POST['contact_email'] ?? ''),
        'updated' => now(),
    ]);
    flash('success', 'Ayarlar güncellendi.');
    redirect('/admin/settings/');
}

include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Genel Ayarlar</h1>
    <form method="post" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Site Adı <input name="site_name" value="<?= e($settings['site_name'] ?? '') ?>"></label>
      <label>Base URL <input name="base_url" value="<?= e($settings['base_url'] ?? '') ?>"></label>
      <label>Support Email <input name="support_email" value="<?= e($settings['support_email'] ?? '') ?>"></label>
      <label>Contact Email <input name="contact_email" value="<?= e($settings['contact_email'] ?? '') ?>"></label>
      <label><input type="checkbox" name="maintenance_mode" <?= !empty($settings['maintenance_mode']) ? 'checked' : '' ?>> Bakım Modu</label>
      <label>Bakım Mesajı <textarea name="maintenance_message"><?= e($settings['maintenance_message'] ?? '') ?></textarea></label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
