<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$settings = DB::query('SELECT * FROM settings WHERE id = 1')->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/settings/footer/');
    }

    DB::query('UPDATE settings SET footer_privacy_md = :privacy, footer_kvkk_md = :kvkk, footer_terms_md = :terms, updated_at = :updated WHERE id = 1', [
        'privacy' => trim($_POST['footer_privacy_md'] ?? ''),
        'kvkk' => trim($_POST['footer_kvkk_md'] ?? ''),
        'terms' => trim($_POST['footer_terms_md'] ?? ''),
        'updated' => now(),
    ]);
    flash('success', 'Footer güncellendi.');
    redirect('/admin/settings/footer/');
}

include __DIR__ . '/../../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Footer Metinleri</h1>
    <form method="post" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Gizlilik <textarea name="footer_privacy_md"><?= e($settings['footer_privacy_md'] ?? '') ?></textarea></label>
      <label>KVKK <textarea name="footer_kvkk_md"><?= e($settings['footer_kvkk_md'] ?? '') ?></textarea></label>
      <label>Koşullar <textarea name="footer_terms_md"><?= e($settings['footer_terms_md'] ?? '') ?></textarea></label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../../app/views/partials/footer.php'; ?>
