<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$id = (int) ($_GET['id'] ?? 0);
$plugin = DB::query('SELECT * FROM plugins WHERE id = :id', ['id' => $id])->fetch();
if (!$plugin) {
    exit('Eklenti bulunamadı.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/plugins/upload/?id=' . $id);
    }

    $file = $_FILES['file'] ?? null;
    if (!$file || $file['error'] !== UPLOAD_ERR_OK) {
        flash('error', 'Dosya yüklenemedi.');
        redirect('/admin/plugins/upload/?id=' . $id);
    }

    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if ($ext !== 'jar') {
        flash('error', 'Sadece .jar dosyası kabul edilir.');
        redirect('/admin/plugins/upload/?id=' . $id);
    }

    $uploadDir = __DIR__ . '/../../../../app/storage/uploads/plugins/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $filename = bin2hex(random_bytes(12)) . '.jar';
    $targetPath = $uploadDir . $filename;
    move_uploaded_file($file['tmp_name'], $targetPath);

    $version = trim($_POST['version'] ?? '1.0.0');
    if (isset($_POST['auto_bump'])) {
        $latest = DB::query('SELECT version FROM plugin_versions WHERE plugin_id = :id ORDER BY created_at DESC LIMIT 1', ['id' => $id])->fetch();
        $version = bump_version($latest['version'] ?? '1.0.0', $_POST['bump_type'] ?? 'patch');
    }

    DB::query('INSERT INTO plugin_versions (plugin_id, version, file_path, file_sha256, changelog_md, created_at, uploaded_by, is_public) VALUES (:plugin, :version, :file, :sha, :changelog, :created, :user, :public)', [
        'plugin' => $id,
        'version' => $version,
        'file' => 'uploads/plugins/' . $filename,
        'sha' => hash_file('sha256', $targetPath),
        'changelog' => trim($_POST['changelog_md'] ?? ''),
        'created' => now(),
        'user' => Auth::user()['id'],
        'public' => isset($_POST['is_public']) ? 1 : 0,
    ]);

    flash('success', 'Sürüm yüklendi.');
    redirect('/admin/plugins/');
}

function bump_version(string $current, string $type): string
{
    $parts = array_map('intval', explode('.', $current));
    $parts += [0, 0, 0];
    if ($type === 'major') {
        $parts[0]++;
        $parts[1] = 0;
        $parts[2] = 0;
    } elseif ($type === 'minor') {
        $parts[1]++;
        $parts[2] = 0;
    } else {
        $parts[2]++;
    }
    return implode('.', $parts);
}

include __DIR__ . '/../../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Sürüm Yükle - <?= e($plugin['name']) ?></h1>
    <form method="post" enctype="multipart/form-data" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Dosya (.jar) <input type="file" name="file" required></label>
      <label>Versiyon <input name="version"></label>
      <label>Changelog <textarea name="changelog_md"></textarea></label>
      <label><input type="checkbox" name="auto_bump"> Otomatik sürüm arttır</label>
      <label>Bump Tipi
        <select name="bump_type">
          <option value="patch">Patch</option>
          <option value="minor">Minor</option>
          <option value="major">Major</option>
        </select>
      </label>
      <label><input type="checkbox" name="is_public" checked> Public</label>
      <button class="btn primary" type="submit">Yükle</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../../app/views/partials/footer.php'; ?>
