<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/plugins/');
    }

    DB::query('INSERT INTO plugins (slug, name, short_description, description_html, price_monthly_try, is_active, theme_primary, theme_accent, created_at, updated_at) VALUES (:slug, :name, :short, :desc, :price, :active, :primary, :accent, :created, :updated)', [
        'slug' => trim($_POST['slug'] ?? ''),
        'name' => trim($_POST['name'] ?? ''),
        'short' => trim($_POST['short_description'] ?? ''),
        'desc' => trim($_POST['description_html'] ?? ''),
        'price' => (float) ($_POST['price_monthly_try'] ?? 0),
        'active' => isset($_POST['is_active']) ? 1 : 0,
        'primary' => trim($_POST['theme_primary'] ?? '#1a73e8'),
        'accent' => trim($_POST['theme_accent'] ?? '#34a853'),
        'created' => now(),
        'updated' => now(),
    ]);
    flash('success', 'Eklenti eklendi.');
    redirect('/admin/plugins/');
}

$plugins = DB::query('SELECT * FROM plugins ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Eklentiler</h1>
    <form method="post" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Slug <input name="slug" required></label>
      <label>Ad <input name="name" required></label>
      <label>Kısa Açıklama <input name="short_description"></label>
      <label>Açıklama <textarea name="description_html"></textarea></label>
      <label>Fiyat (TRY) <input name="price_monthly_try" type="number" step="0.01"></label>
      <label>Primary <input name="theme_primary" value="#1a73e8"></label>
      <label>Accent <input name="theme_accent" value="#34a853"></label>
      <label><input type="checkbox" name="is_active" checked> Aktif</label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
    <div class="cards">
      <?php foreach ($plugins as $plugin): ?>
        <div class="content-card">
          <strong><?= e($plugin['name']) ?></strong>
          <div class="actions">
            <a class="btn small" href="/admin/plugins/edit/?id=<?= e((string) $plugin['id']) ?>">Düzenle</a>
            <a class="btn small" href="/admin/plugins/upload/?id=<?= e((string) $plugin['id']) ?>">Sürüm Yükle</a>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
