<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$id = (int) ($_GET['id'] ?? 0);
$plugin = DB::query('SELECT * FROM plugins WHERE id = :id', ['id' => $id])->fetch();
if (!$plugin) {
    exit('Eklenti bulunamadı.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/plugins/edit/?id=' . $id);
    }
    DB::query('UPDATE plugins SET name = :name, short_description = :short, description_html = :desc, price_monthly_try = :price, is_active = :active, theme_primary = :primary, theme_accent = :accent, updated_at = :updated WHERE id = :id', [
        'name' => trim($_POST['name'] ?? ''),
        'short' => trim($_POST['short_description'] ?? ''),
        'desc' => trim($_POST['description_html'] ?? ''),
        'price' => (float) ($_POST['price_monthly_try'] ?? 0),
        'active' => isset($_POST['is_active']) ? 1 : 0,
        'primary' => trim($_POST['theme_primary'] ?? '#1a73e8'),
        'accent' => trim($_POST['theme_accent'] ?? '#34a853'),
        'updated' => now(),
        'id' => $id,
    ]);
    flash('success', 'Eklenti güncellendi.');
    redirect('/admin/plugins/');
}

include __DIR__ . '/../../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Eklenti Düzenle</h1>
    <form method="post" class="content-card">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <label>Ad <input name="name" value="<?= e($plugin['name']) ?>"></label>
      <label>Kısa Açıklama <input name="short_description" value="<?= e($plugin['short_description']) ?>"></label>
      <label>Açıklama <textarea name="description_html"><?= e($plugin['description_html']) ?></textarea></label>
      <label>Fiyat <input name="price_monthly_try" type="number" step="0.01" value="<?= e((string) $plugin['price_monthly_try']) ?>"></label>
      <label>Primary <input name="theme_primary" value="<?= e($plugin['theme_primary']) ?>"></label>
      <label>Accent <input name="theme_accent" value="<?= e($plugin['theme_accent']) ?>"></label>
      <label><input type="checkbox" name="is_active" <?= $plugin['is_active'] ? 'checked' : '' ?>> Aktif</label>
      <button class="btn primary" type="submit">Kaydet</button>
    </form>
  </div>
</div>
<?php include __DIR__ . '/../../../../app/views/partials/footer.php'; ?>
