<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$orders = DB::query('SELECT orders.*, users.email FROM orders JOIN users ON users.id = orders.user_id ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Siparişler</h1>
    <?php foreach ($orders as $order): ?>
      <div class="content-card">
        <strong><?= e($order['order_no']) ?></strong>
        <p><?= e($order['email']) ?> - <?= e($order['status']) ?></p>
        <p>₺<?= number_format((float) $order['total_try'], 2) ?></p>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
