<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

$stats = [
    'orders' => DB::query('SELECT COUNT(*) as c FROM orders')->fetch()['c'] ?? 0,
    'licenses' => DB::query('SELECT COUNT(*) as c FROM licenses')->fetch()['c'] ?? 0,
    'bugs' => DB::query('SELECT COUNT(*) as c FROM bug_reports WHERE status != \'resolved\'')->fetch()['c'] ?? 0,
];

include __DIR__ . '/../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Admin Dashboard</h1>
    <div class="cards">
      <div class="content-card">Siparişler: <?= e((string) $stats['orders']) ?></div>
      <div class="content-card">Aktif Lisanslar: <?= e((string) $stats['licenses']) ?></div>
      <div class="content-card">Açık Bug: <?= e((string) $stats['bugs']) ?></div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../app/views/partials/footer.php'; ?>
