<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/comments/');
    }
    DB::query('UPDATE comments SET status = :status, moderated_by = :admin, updated_at = :updated WHERE id = :id', [
        'status' => $_POST['status'] ?? 'approved',
        'admin' => Auth::user()['id'],
        'updated' => now(),
        'id' => (int) $_POST['comment_id'],
    ]);
    flash('success', 'Yorum güncellendi.');
    redirect('/admin/comments/');
}

$comments = DB::query('SELECT comments.*, users.username, plugins.name AS plugin_name FROM comments JOIN users ON users.id = comments.user_id JOIN plugins ON plugins.id = comments.plugin_id WHERE status = \'pending\' ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Yorum Moderasyonu</h1>
    <?php foreach ($comments as $comment): ?>
      <form method="post" class="content-card">
        <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
        <input type="hidden" name="comment_id" value="<?= e((string) $comment['id']) ?>">
        <strong><?= e($comment['username']) ?> - <?= e($comment['plugin_name']) ?></strong>
        <p><?= e($comment['content']) ?></p>
        <select name="status">
          <option value="approved">Onayla</option>
          <option value="rejected">Reddet</option>
        </select>
        <button class="btn small" type="submit">Uygula</button>
      </form>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
