<?php
declare(strict_types=1);

require_once __DIR__ . '/../../../app/bootstrap.php';
if (!Auth::isAdmin()) {
    http_response_code(403);
    exit('Yetkisiz.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!CSRF::validate($_POST['_csrf'] ?? '')) {
        flash('error', 'Geçersiz CSRF.');
        redirect('/admin/bugs/');
    }
    DB::query('UPDATE bug_reports SET status = :status, admin_notes = :notes, updated_at = :updated WHERE id = :id', [
        'status' => $_POST['status'] ?? 'open',
        'notes' => trim($_POST['admin_notes'] ?? ''),
        'updated' => now(),
        'id' => (int) $_POST['bug_id'],
    ]);
    flash('success', 'Bug güncellendi.');
    redirect('/admin/bugs/');
}

$bugs = DB::query('SELECT bug_reports.*, plugins.name AS plugin_name FROM bug_reports JOIN plugins ON plugins.id = bug_reports.plugin_id ORDER BY created_at DESC')->fetchAll();
include __DIR__ . '/../../../app/views/partials/header.php';
?>
<div class="container dashboard">
  <?php include __DIR__ . '/../../../app/views/partials/admin_sidebar.php'; ?>
  <div class="dashboard-content">
    <h1>Bug Raporları</h1>
    <?php foreach ($bugs as $bug): ?>
      <form method="post" class="content-card">
        <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
        <input type="hidden" name="bug_id" value="<?= e((string) $bug['id']) ?>">
        <strong><?= e($bug['title']) ?> (<?= e($bug['plugin_name']) ?>)</strong>
        <p><?= e($bug['description']) ?></p>
        <select name="status">
          <?php foreach (['open','investigating','resolved','closed','duplicate'] as $status): ?>
            <option value="<?= $status ?>" <?= $bug['status'] === $status ? 'selected' : '' ?>><?= $status ?></option>
          <?php endforeach; ?>
        </select>
        <textarea name="admin_notes" placeholder="Admin notları"><?= e($bug['admin_notes'] ?? '') ?></textarea>
        <button class="btn small" type="submit">Güncelle</button>
      </form>
    <?php endforeach; ?>
  </div>
</div>
<?php include __DIR__ . '/../../../app/views/partials/footer.php'; ?>
