<?php
$user = Auth::user();
$settings = DB::query('SELECT * FROM settings WHERE id = 1')->fetch();
$siteName = $settings['site_name'] ?? 'xoraGames';
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e($siteName) ?></title>
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<header class="site-header">
  <div class="container">
    <div class="brand">
      <a href="/"><?= e($siteName) ?></a>
    </div>
    <nav class="main-nav">
      <a href="/plugins/">Eklentiler</a>
      <a href="/wiki/">Wiki</a>
      <a href="/panel/">Panel</a>
      <?php if ($user): ?>
        <a href="/logout/">Çıkış</a>
      <?php else: ?>
        <a href="/login/">Giriş</a>
      <?php endif; ?>
    </nav>
  </div>
</header>
<main class="content">
