<?php
declare(strict_types=1);

function e(string $value): string
{
    return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
}

function url(string $path = ''): string
{
    $base = rtrim((string) config('APP_BASE_URL', ''), '/');
    return $base . '/' . ltrim($path, '/');
}

function redirect(string $path): void
{
    header('Location: ' . $path);
    exit;
}

function flash(string $key, string $message): void
{
    $_SESSION['flash_' . $key] = $message;
}

function flash_get(string $key): ?string
{
    $flashKey = 'flash_' . $key;
    if (!isset($_SESSION[$flashKey])) {
        return null;
    }
    $message = $_SESSION[$flashKey];
    unset($_SESSION[$flashKey]);
    return $message;
}

function old(string $key, string $default = ''): string
{
    return isset($_POST[$key]) ? e((string)$_POST[$key]) : e($default);
}

function config(string $key, mixed $default = null): mixed
{
    return $GLOBALS['config'][$key] ?? $default;
}

function view(string $path, array $data = []): void
{
    extract($data, EXTR_SKIP);
    include __DIR__ . '/views/' . ltrim($path, '/');
}

function now(): string
{
    return (new DateTimeImmutable('now', new DateTimeZone('Europe/Istanbul')))->format('Y-m-d H:i:s');
}
