<?php
declare(strict_types=1);

final class ShopierProvider implements PaymentProviderInterface
{
    public function createPayment(array $order, array $customerContext): array
    {
        return [
            'redirect_url' => '/panel/orders/',
            'payload' => ['mock' => true],
        ];
    }

    public function verifyWebhook(array $payload, array $headers): array
    {
        return ['valid' => true, 'order_no' => $payload['platform_order_id'] ?? null];
    }

    public function handleSuccessReturn(array $payload): void
    {
        Logger::log('payment.log', 'Shopier success: ' . json_encode($payload));
    }

    public function handleFailureReturn(array $payload): void
    {
        Logger::log('payment.log', 'Shopier failure: ' . json_encode($payload));
    }
}
