<?php
declare(strict_types=1);

final class PaymentManager
{
    public static function provider(string $name): PaymentProviderInterface
    {
        return match ($name) {
            'paytr' => new PayTRProvider(),
            'iyzico' => new IyzicoProvider(),
            'shopier' => new ShopierProvider(),
            default => throw new InvalidArgumentException('Unknown payment provider.'),
        };
    }
}
