<?php
declare(strict_types=1);

final class PayTRProvider implements PaymentProviderInterface
{
    public function createPayment(array $order, array $customerContext): array
    {
        return [
            'redirect_url' => '/panel/orders/',
            'payload' => ['mock' => true],
        ];
    }

    public function verifyWebhook(array $payload, array $headers): array
    {
        return ['valid' => true, 'order_no' => $payload['merchant_oid'] ?? null];
    }

    public function handleSuccessReturn(array $payload): void
    {
        Logger::log('payment.log', 'PayTR success: ' . json_encode($payload));
    }

    public function handleFailureReturn(array $payload): void
    {
        Logger::log('payment.log', 'PayTR failure: ' . json_encode($payload));
    }
}
