<?php
declare(strict_types=1);

final class Mailer
{
    public static function send(string $to, string $subject, string $body): bool
    {
        $settings = DB::query('SELECT * FROM settings WHERE id = 1')->fetch();
        if (!$settings || empty($settings['smtp_host'])) {
            return false;
        }

        $headers = [
            'From: ' . $settings['smtp_from'],
            'Content-Type: text/html; charset=UTF-8',
        ];

        return mail($to, $subject, $body, implode("\r\n", $headers));
    }
}
