<?php
declare(strict_types=1);

final class Logger
{
    public static function log(string $file, string $message): void
    {
        $path = __DIR__ . '/../storage/logs/' . $file;
        $line = sprintf("[%s] %s\n", now(), $message);
        file_put_contents($path, $line, FILE_APPEND | LOCK_EX);
    }
}
