<?php
declare(strict_types=1);

final class LicenseSigner
{
    public static function sign(string $licenseKey, string $pluginSlug, string $expiresAt, string $serverId, string $appKey): string
    {
        $payload = implode('|', [$licenseKey, $pluginSlug, $expiresAt, $serverId]);
        return hash_hmac('sha256', $payload, $appKey);
    }
}
