<?php
declare(strict_types=1);

final class CSRF
{
    public static function init(): void
    {
        if (!isset($_SESSION['_csrf_token'])) {
            $_SESSION['_csrf_token'] = bin2hex(random_bytes(32));
        }
    }

    public static function token(): string
    {
        return $_SESSION['_csrf_token'] ?? '';
    }

    public static function validate(?string $token): bool
    {
        return hash_equals($_SESSION['_csrf_token'] ?? '', (string) $token);
    }
}
