<?php
declare(strict_types=1);

final class Auth
{
    private static array $config = [];

    public static function init(array $config): void
    {
        self::$config = $config;
    }

    public static function user(): ?array
    {
        if (!isset($_SESSION['user_id'])) {
            return null;
        }

        $stmt = DB::query('SELECT * FROM users WHERE id = :id LIMIT 1', [
            'id' => $_SESSION['user_id'],
        ]);

        $user = $stmt->fetch();
        return $user ?: null;
    }

    public static function check(): bool
    {
        return self::user() !== null;
    }

    public static function isAdmin(): bool
    {
        $user = self::user();
        return $user && $user['role'] === 'admin';
    }

    public static function attempt(string $email, string $password): bool
    {
        $stmt = DB::query('SELECT * FROM users WHERE email = :email LIMIT 1', [
            'email' => $email,
        ]);
        $user = $stmt->fetch();
        if (!$user) {
            return false;
        }

        if (!password_verify($password, $user['password_hash'])) {
            return false;
        }

        $_SESSION['user_id'] = (int) $user['id'];
        $_SESSION['last_login_at'] = time();
        DB::query('UPDATE users SET last_login_at = :at, last_login_ip = :ip WHERE id = :id', [
            'at' => now(),
            'ip' => $_SERVER['REMOTE_ADDR'] ?? null,
            'id' => $user['id'],
        ]);
        session_regenerate_id(true);
        return true;
    }

    public static function logout(): void
    {
        unset($_SESSION['user_id']);
        session_regenerate_id(true);
    }
}
