<?php
declare(strict_types=1);

require_once __DIR__ . '/helpers.php';

$configPath = __DIR__ . '/config/config.php';
if (!file_exists($configPath)) {
    if (!headers_sent()) {
        header('Location: /install/');
    }
    exit;
}

require_once $configPath;
if (!isset($GLOBALS['config']) && isset($config)) {
    $GLOBALS['config'] = $config;
}

require_once __DIR__ . '/core/DB.php';
require_once __DIR__ . '/core/Auth.php';
require_once __DIR__ . '/core/CSRF.php';
require_once __DIR__ . '/core/Logger.php';
require_once __DIR__ . '/core/Validator.php';
require_once __DIR__ . '/core/Mailer.php';
require_once __DIR__ . '/core/Security.php';
require_once __DIR__ . '/core/Payment/PaymentProviderInterface.php';
require_once __DIR__ . '/core/Payment/PaymentManager.php';
require_once __DIR__ . '/core/Payment/PayTRProvider.php';
require_once __DIR__ . '/core/Payment/IyzicoProvider.php';
require_once __DIR__ . '/core/Payment/ShopierProvider.php';
require_once __DIR__ . '/core/License/LicenseService.php';
require_once __DIR__ . '/core/License/LicenseApiController.php';
require_once __DIR__ . '/core/License/LicenseSigner.php';

session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off',
    'httponly' => true,
    'samesite' => 'Lax',
]);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

DB::init($config);
Auth::init($config);
Security::applySecurityHeaders();

if (Security::isMaintenanceMode() && !Auth::isAdmin()) {
    http_response_code(503);
    include __DIR__ . '/views/partials/maintenance.php';
    exit;
}

CSRF::init();
Security::enforceSessionFreshness();
