# xoraGames License Platform

Bu proje, Minecraft eklentileri için aylık lisans satış platformudur. `public_html/` dizini hosting köküne kopyalanarak çalıştırılabilir.

## Kurulum
1. **Dosyaları yükleyin:** `public_html/` klasörünü hosting `public_html` dizinine kopyalayın. `app/` ve `sql/` dizinleri public root dışında kalmalı.
2. **Tarayıcıda açın:** `https://alanadiniz.xyz/` ziyaret edildiğinde kurulum sihirbazı açılır.
3. **Kurulum adımları:**
   - Sistem kontrolü
   - DB bilgileri
   - Şema oluşturma
   - İlk admin hesabı
   - Temel ayarlar
4. Kurulum sonunda `app/config/config.php` dosyası oluşturulur ve `install/.lock` yazılır.

## Cron Önerileri
- **Lisans hatırlatmaları:** `php scripts/cron/license_reminder.php`
- **Sitemap yenileme:** `php scripts/cron/sitemap_refresh.php`

## Ödeme Sağlayıcı Ayarları
Admin panelde `Ödemeler` bölümünde sağlayıcı anahtarları girilir. (PayTR, Shopier, iyzico).
Webhook adresleri:
- PayTR: `/admin/payments/webhooks/paytr.php`
- iyzico: `/admin/payments/webhooks/iyzico.php`
- Shopier: `/admin/payments/webhooks/shopier.php`

## Güvenlik Notları
- Tüm DB sorguları PDO prepared statements kullanır.
- CSRF token tüm formlarda uygulanır.
- `install/` dizini kurulumdan sonra silinmelidir.

## Hosting Notu
- Apache için `.htaccess` içerir.
- Nginx için rewrite kuralları eklenmelidir.

## Config Örneği
`app/config/config.sample.php` dosyasına bakın.
